;___XIO________________________________________________________________________________________________________________
;
; DIRECT SERIAL I/O
;
;   PROVIDES INTERFACE TO PLATFORM BASE SERIAL I/O DEVICE
;   ALLOWS USER MESSAGING/INTERACTION PRIOR TO AND DURING HBIOS INIT
;______________________________________________________________________________________________________________________
;
XIO_INIT:	; MINIMAL UART INIT
#IF (PLATFORM == PLT_N8)
	; ASCI0
	LD	A,66H
	OUT0	(CPU_ASEXT0),A
	LD	A,64H
	OUT0	(CPU_CNTLA0),A
	LD	A,Z180_CNTLB0
	OUT0	(CPU_CNTLB0),A
	RET
#ELSE
XIO_DIV		.EQU	(1843200 / (16 * BAUDRATE))

	LD	A,$80			; LCR := DLAB ON
	OUT	(SIO_LCR),A		; SET LCR
	LD	A,XIO_DIV		; BAUD RATE DIVISOR (LSB)
	OUT	(SIO_DLL),A		; SET DIVISOR (LSB)
	XOR	A			; BAUD RATE DIVISOR (MSB), ALWAYS 0
	OUT	(SIO_DLM),A		; SET DIVISOR (MSB)
	LD	A,03H			; VALUE FOR LCR AND MCR
	OUT	(SIO_LCR),A		; LCR := 3, DLAB OFF, 8 DATA, 1 STOP, NO PARITY
	OUT  	(SIO_MCR),A		; MCR := 3, DTR ON, RTS ON
	LD	A,6			; DISABLE & RESET FIFO'S
	OUT	(SIO_FCR),A		; DO IT
	RET
#ENDIF
;
XIO_CRLF:	; OUTPUT A NEWLINE
	LD	A,13			; A = CR
	CALL	XIO_OUTC		; WRITE IT
	LD	A,10			; A = LF
	JR	XIO_OUTC		; WRITE IT
;
XIO_SPACE:	; OUTPUT A SPACE CHARACTER
	LD	A,' '
	JR	XIO_OUTC
;
XIO_DOT:	; OUTPUT A DOT (MARK PROGRESS)
	LD	A,'.'
;	
XIO_OUTC:	; OUTPUT BYTE IN A
#IF (PLATFORM == PLT_N8)
	PUSH	AF			; SAVE INCOMING BYTE
XIO_OUTC1:
	IN0	A,(CPU_STAT0)
	AND	$02
	JR	Z,XIO_OUTC1
	POP	AF
	OUT0	(CPU_TDR0),A
	RET
#ELSE
	PUSH	AF			; SAVE INCOMING BYTE
XIO_OUTC1:
	IN	A,(SIO_LSR)		; READ LINE STATUS REGISTER
	AND	$20			; ISOLATE THRE
	JR	Z,XIO_OUTC1		; LOOP TILL READY (EMPTY)
	POP	AF			; RECOVER BYTE TO WRITE
	OUT	(SIO_THR),A		; WRITE THE CHAR TO UART
	RET
#ENDIF
;
XIO_OUTS:	; OUTPUT '$' TERMINATED STRING AT ADDRESS IN HL
	LD	A,(HL)			; GET NEXT BYTE
	CP	'$'			; END OF STRING?
	RET	Z			; YES, GET OUT
	CALL	XIO_OUTC		; OTHERWISE, WRITE IT
	INC	HL			; POINT TO NEXT BYTE
	JR	XIO_OUTS		; AND LOOP
