;
; N8VEM HARDWARE IO PORT ADDRESSES AND MEMORY LOCATIONS
;
MPCL_RAM	.EQU 	78H		; BASE IO ADDRESS OF RAM MEMORY PAGER CONFIGURATION LATCH
MPCL_ROM	.EQU 	7CH		; BASE IO ADDRESS OF ROM MEMORY PAGER CONFIGURATION LATCH
RTC		.EQU	70H		; ADDRESS OF RTC LATCH AND INPUT PORT
;
; PPI 82C55 I/O IS DECODED TO PORT 60-67
;
PPIBASE		.EQU	80H
PPIA		.EQU 	PPIBASE + 0	; PORT A
PPIB		.EQU 	PPIBASE + 1	; PORT B
PPIC		.EQU 	PPIBASE + 2	; PORT C
PPIX	 	.EQU 	PPIBASE + 3	; PPI CONTROL PORT
;
; 16C550 SERIAL LINE UART
;
SIO_BASE	.EQU	90H
SIO_RBR		.EQU	SIO_BASE + 0	; DLAB=0: RCVR BUFFER REG (READ ONLY)
SIO_THR		.EQU	SIO_BASE + 0	; DLAB=0: XMIT HOLDING REG (WRITE ONLY)
SIO_IER		.EQU	SIO_BASE + 1	; DLAB=0: INT ENABLE REG
SIO_IIR		.EQU	SIO_BASE + 2	; INT IDENT REGISTER (READ ONLY)
SIO_FCR		.EQU	SIO_BASE + 2	; FIFO CONTROL REG (WRITE ONLY)
SIO_LCR		.EQU	SIO_BASE + 3	; LINE CONTROL REG
SIO_MCR		.EQU	SIO_BASE + 4	; MODEM CONTROL REG
SIO_LSR		.EQU	SIO_BASE + 5	; LINE STATUS REG
SIO_MSR		.EQU	SIO_BASE + 6	; MODEM STATUS REG
SIO_SCR		.EQU	SIO_BASE + 7	; SCRATCH REGISTER
SIO_DLL		.EQU	SIO_BASE + 0	; DLAB=1: DIVISOR LATCH (LS)
SIO_DLM		.EQU	SIO_BASE + 1	; DLAB=1: DIVISOR LATCH (MS)
