/*
 * Copyright (c) 2010, Takashi TOYOSHIMA <toyoshim@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of the authors nor the names of its contributors may be
 *   used to endorse or promote products derived from this software with out
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUE
 * NTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Original idea by Takashi TOYOSHIMA, heavily modified by Rienk Koolstra to
 * implement memory bank switching and RTS handshaking for the UART.
 * SDcard interface moved to B-port SPI pins. Some memory control pins moved
 * to C-port to free up C-2 to be used as RTS signal.
 */


.equ	DOUT,11		/* Port D data out */
.equ	DDIR,10		/* Port D Direction */
.equ	DIN,9			/* Port D Data in */
.equ	B_PORT,5	/* Port B data */
.equ	C_PORT,8	/* Port C data */

.equ	nWR,0		/* ~WRITE/READ */
.equ	CE2,1		/* SRAM Chip enable 2 */
.equ	C_L,3		/* low address latch clock (positive edge triggered) */
.equ	C_H,4		/* high address latch clock */
.equ	A16,5		/* SRAM address bit 16 */

.equ	DATA_IN,0
.equ	DATA_OUT,0xff

.macro _sram_read adr_l=r24, adr_h=r25, ret=r24, work=r23
	out DOUT,\adr_l	/* output address low */
	sbi C_PORT,C_L	/* clock low latch */
	mov \work,r6		/* get memory bank (0-3) */
	sbrc \adr_h,7		/* using system bank?	*/
	ldi \work,1			/* set bank 1 */
	bst \work,0			/* put bank bit	0 */
	bld \adr_h,7		/* into address bit 15 */
	sbrc \work,1		/* put bank bit 1 */
	sbi C_PORT,A16	/* into address bit 16 */
	out DOUT,\adr_h	/* output address high */
	sbi C_PORT,C_H	/* clock high latch */
	out DDIR,r1			/* data port as input */
	sbi B_PORT,nWR	/* set SRAM READ */
	sbi B_PORT,CE2	/* set SRAM Chip enable */
	out DOUT,r1			/* disable pull-ups */
	ldi \work,DATA_OUT
	cbi C_PORT,C_H	/* all signals back to low */
	cbi C_PORT,C_L
	cbi B_PORT,CE2
	cbi C_PORT,A16
	in \ret,DIN			/* read data from SRAM */
	out DDIR,\work	/* set data port as output  */
.endm

.macro _sram_write adr_l=r24, adr_h=r25, data=r22, work=r23
	out DOUT,\adr_l	/* output address low */
	sbi C_PORT,C_L	/* clock low latch */
	mov \work,r6		/* get memory bank (0-3) */
	sbrc \adr_h,7		/* using system bank?	*/
	ldi \work,1			/* set bank 1 */
	bst \work,0			/* put bank bit	0 */
	bld \adr_h,7		/* into address bit 15 */
	sbrc \work,1		/* put bank bit 1 */
	sbi C_PORT,A16	/* into address bit 16 */
	out DOUT,\adr_h	/* output address high */
	sbi C_PORT,C_H	/* clock high latch */
	out DOUT,\data	/* output data */
	cbi B_PORT,nWR	/* set SRAM WRITE */
	sbi B_PORT,CE2	/* set SRAM Chip enable */
	cbi C_PORT,C_L	/* all signals back to low */
	cbi C_PORT,C_H
	cbi B_PORT,CE2
	sbi B_PORT,nWR	/* except SRAM ~WR */
	cbi C_PORT,A16
.endm

.macro _sram_bank bank=r24
	mov r6,r24			/* r6 is system wide bank in use */
.endm
