/*
 * Copyright (c) 2016, Takashi TOYOSHIMA <toyoshim@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of the authors nor the names of its contributors may be
 *   used to endorse or promote products derived from this software with out
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUE
 * NTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * 
 * Modified by Rienk Koolstra to include bank switching. Also SRAM control port 
 * pins were moved to free up pin C2, to be used as RTS handshake pin.
 */

#include "sram.h"

#include <avr/io.h>

void
sram_init
(void)
{
  /*
   * PB0: /W
   * PB1: E2
   * PB2: A16
   * PB3: N/A (input)
   * PB4: CLK for FF on Address Low
   * PB5: CLK for FF on Address High
   * PD*: Address / Data
   */
  /*
   * PB0: /W
   * PB1: E2
   * PC3: CLK for FF on Address Low
   * PC4: CLK for FF on Address High
   * PC5: A16
   * PD*: Address / Data
   */
  // Port Settings

	/* all output */
  DDRB    |= (_BV(DDB0) | _BV(DDB1));
  DDRC		|= (_BV(DDC3) | _BV(DDC4) | _BV(DDC5));
  DDRD    = 0xff;
  /* all zero */
  PORTB   &= ~(_BV(DDB0) | _BV(DDB1));
  PORTC		&= ~(_BV(DDC3) | _BV(DDC4) | _BV(DDC5));
  PORTD   = 0;
  sram_bank(0);
 }
