/*
 * Copyright (c) 2010, Takashi TOYOSHIMA <toyoshim@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of the authors nor the names of its contributors may be
 *   used to endorse or promote products derived from this software with out
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUE
 * NTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * 
 * Modified by Rienk Koolstra to include memor bank switching. The 128kB SRAM 
 * is devided in 4 32kB banks which can be swapped in lower memory. 
 * The r6 register holds the current bank number.
 */

	.arch atmega88
	.include "sram_mac.s"
	.text

.global sram_read
	.type	sram_read, @function
sram_read:
	/*
	 * r25: address high
	 * r24: address low
	 *   18 cycles + rcall(3 cycles)
	 */
	_sram_read
	ret
	.size sram_read, .-sram_read

.global sram_write
	.type	sram_write, @function
sram_write:
	/*
	 * r25: address high
	 * r24: address low
	 * r22: data
	 *   14 cycles + rcall(3 cycles)
	 */
	_sram_write
	ret
	.size sram_write, .-sram_write

.global sram_bank
	.type	sram_bank, @function
sram_bank:
	/*
	 * r24: bank number
	 */
	 _sram_bank
	ret
	.size sram_bank, .-sram_bank
