;
; Base page constants
;
Bdos			equ 0005h
FCB1			equ	005Ch	; default FCB1 address
FCB2			equ	006Ch	; default FCB2 address

;
;	BDOS calls
;
reset			equ	00	; system reset
conout		equ 02	; console out
conin			equ 06	; direct console in
prtbuf		equ 09	; print string
cpmver		equ 12	; get CP/M version
dreset		equ 13	; reset disk system
seldsk		equ 14	; select active disk
fopen 		equ 15	; open file
fclose		equ 16	; close file
fdelete		equ 19	; delete file
fread 		equ 20	; read sequential
fwrite		equ 21	; write sequential
fmake			equ 22	; create a new file
curdsk		equ 25	; get current disk
setdma		equ 26	; set dma address
multio		equ 44	; set sequential file io sector count (CP/M3)
dmount		equ 50	; custom bdos call for mounting volumes (CP/M3)
;
; system ports
;
SD_DSK		equ	10	; disk drive
SD_TKL		equ	11	; disk track low
SD_TKH		equ	12	; disk track high
SD_SEC		equ	13	; disk sector
SD_CMD		equ	14	; disk command
SD_STAT		equ	15	; disk status
DMA_L			equ	16	; dma address low
DMA_H			equ	17	; dma address high

cr		equ 0Dh
lf		equ 0Ah

BUFFER		equ 0500h
SysSize		equ 64


	ORG $100

; format: getsys volumenumber targetfile
;
; volumenumber in FCB1+1
; convert to binary
	ld hl,FCB1+1
	call DecToBinary
; check volume number (2-254)
	ld a,d
	or a
	jp nz,BadVolume
	ld a,e
	inc a
	cp 3
	jp c,NeedHelp
	dec a

; read system track to BUFFER
readsystem:
	out (SD_DSK),a
	xor a
	out (SD_TKL),a	; set track zero
	out (SD_TKH),a
	ld c,a					; set sector zero
	ld hl,BUFFER
	ld de,128				; buffer size
	ld b,SysSize		; read 8k

readsec:
	ld a,h
	out (DMA_H),a
	ld a,l
	out (DMA_L),a
	ld a,c
	out (SD_SEC),a
	xor a
	out (SD_CMD),A
	add hl,de
	inc c
	dec b
	jp nz,readsec

; get disk system back to normal
	ld c,dreset
	call Bdos

; targetfile in FCB2
; open targetfile
	ld a,(FCB2+1)
	cp '0'
	jp c,BadFile
	ld de,FCB2
	ld c,fopen
	call Bdos
	inc a
	jp z,MakeFile
	
; if present ask to delete
	ld de,Query		; ask consent
	ld c,prtbuf
	call Bdos
yesno:
	ld e,0FFh
	ld c,conin
	call Bdos
  and 05Fh				; make upper case
  jp z,yesno			; no character
  push af
	ld e,a
	ld c,conout
	call Bdos
	pop af
  cp 'Y'					; only 'Y' will do
  jp nz,Abort			; no means no
  
;  delete targetfile
	ld de,FCB2
	ld c,fdelete
	call Bdos

; make targetfile
MakeFile:
	ld de,FCB2
	ld c,fmake
	call Bdos
	inc a
	jp z,NoMake
;
; now copy memory to target file
;
	ld hl,BUFFER
	ld de,128					; block size
	ex de,hl
	ld b,SysSize			; file counter
writesec:
	push bc
	push de
	push hl
	ld c,setdma				; set DMA to DE
	call Bdos
	ld de,FCB2
	ld c,fwrite
	call Bdos
	pop de
	pop hl
	pop bc
	add hl,de	
	ex de,hl
	dec b						; decrement file counter
	jp nz,writesec
; close target
fileclose:				; close the file
	ld de,FCB2
	ld c,fclose
	call Bdos
	jp Success


DecToBinary:
	push af
	push bc
	ld de,0
	push de
DecToBloop:
	ld a,(hl)
	sub '0'
	jp c,DecToBdone
	cp 9+1
	jp nc,DecToBdone
	ld e,a
	ex (sp),hl
	ld b,h
	ld c,l
	add hl,hl
	add hl,hl
	add hl,bc
	add hl,hl
	add hl,de
	ex (sp),hl
	inc hl
	jp DecToBloop
	
DecToBdone:
	pop de
	pop bc
	pop af
	ret
	
BadVolume:
	ld de,VolumeError
	jp PrintIt
BadFile:
	ld de,FileError
	jp PrintIt
NoMake:
	ld de,MakeError
	jp PrintIt
Abort:
	ld de,AbortMessage
	jp PrintIt
Success:
	ld de,SuccessMsg
PrintIt:
	ld c,prtbuf
	call Bdos
	ld c,reset
	jp Bdos

NeedHelp:
	ld a,(FCB1+1)
	cp '/'
	jp nz,BadVolume
	ld a,(FCB1+2)
	cp '?'
	jp nz,BadVolume
	ld de,HelpText
	jp PrintIt
	
HelpText:
	db cr,lf,'Usage: GETSYS Volume imagefile'
	db cr,lf
	db cr,lf,'       Volume is a number 2-254'
	db cr,lf,'       imagefile will not be over'
	db cr,lf,'       written without consent$'


Query:
	db cr,lf,'File exists. Erase? $'

VolumeError:
	db cr,lf,'Bad or missing volume',cr,lf,'$'
FileError:
	db cr,lf,'Missing target file',cr,lf,'$'
MakeError:
	db cr,lf,'Error creating target file',cr,lf,'$'
AbortMessage:
	db cr,lf,'Aborted',cr,lf,'$'	
SuccessMsg:
	db	cr,lf,'System saved',cr,lf,'$'

end
