; FORMAT - write empty directory to selected volume and add a volume label
;-------------------------------------------------------------
COMTAIL		equ 80h
BDOS		equ 0005h

SD_DSK	equ	10		; disk drive
SD_TKL	equ	11		; disk track low
SD_TKH	equ	12		; disk track high
SD_SEC	equ	13		; disk sector
SD_CMD	equ	14		; disk command
SD_STAT	equ	15		; disk status
DMA_L	equ	16		; dma address low
DMA_H	equ	17		; dma address high

CR		equ 0Dh
LF		equ 0Ah

ORG $100

parse:
	ld HL,COMTAIL	; find the command tail end
	ld C,(HL)
	ld B,0
	add HL,BC

	ld B,C					; there should be no more than 3 numbers
	dec B
	ld C,0					; valid flag
	ld DE,VNUM+2		; destination message
parse1:
	call GetChr
	jp nc,parse2		; not a number
	ld (DE),A				; replace zero with number
	dec DE
	inc C						; at least one number found
	jp parse3
parse2:
	xor A
	cp C
	jp nz,badnumber
parse3:
	dec B
	jp nz,parse1
	xor A
	cp C
	jp z,help			; no number found

	ld HL,VNUM		; destination in volume label
	; convert volume  to binary
	ld A,-110
	push AF
	ld A,(HL)
	cp '3'
	jp nc,help
	sub 2Fh		; make binary
	ld C,A
	pop AF
label1:
	add A,100
	dec C
	jp nz,label1
	inc HL
	inc DE
	push AF
	ld A,(HL)
	sub 2Fh		; make binary
	ld C,A
	pop AF
label2:
	add A,10
	dec C
	jp nz,label2
	inc HL
	inc DE
	push AF
	and A
	jp c,help ; negative, means overflow
	ld A,(HL)
	sub 30h		; make binary
	ld C,A
	pop AF
	add A,C
	push AF
	cp 4
	jp c,help
	ld DE,FMQUERY		; ask consent
	ld C,9
	call BDOS
yesno:
	ld E,0FFh
	ld C,6
	call BDOS
  and 05Fh				; make upper case
  jp z,yesno			; no character
	push af
	ld E,A
	ld C,2
	call BDOS
	pop AF
  cp 'Y'					; only 'Y' will do
  jp nz,abort			; no means no
	ld DE,VNUM
	ld HL,LNUM	
	ld b,3
mklab:						; make volume label
	ld A,(DE)
	ld (HL),A
	inc DE
	inc HL
	dec B
	JP nz,mklab
	ld HL,LNUM			; make read only
	ld A,(HL)
	or 80h
	ld (HL),A

 ; formatting here...
	pop AF
	out (SD_DSK),A ; set volume to format
	ld A,1
	out (SD_TKL),A
	dec A
	out (SD_TKH),A
	out (SD_SEC),A
	ld HL,volImg
	ld A,H
	out (DMA_H),A
	ld A,L
	out (DMA_L),A
	ld DE,32
	add HL,DE
	xor A
	ld B,128
nextsec:
	push AF
	ld A,1
	out (SD_CMD),A
	ld A,H
	out (DMA_H),A
	ld A,L
	out (DMA_L),A
	pop AF
	inc A
	out (SD_SEC),A
	dec B
	jp nz,nextsec

	ld C,0Dh		; reset disk sytem
	call BDOS
	jp signoff

	
GetChr:				; next char
	ld A,(HL)
	dec HL
	cp '0'
	jp c,NoChr	; too small
	cp ':'			; too big
	ret c				; just right
NoChr:
	ld A,0FFh
	or A				; clear carry flag
	ret 				; return character in a
	
help:	pop AF
	ld DE,helptext
	jp exit
abort:	pop AF
	ld DE,abortmessage
	jp exit
badnumber:
	ld DE,numbermessage
	jp exit
signoff: 		
	ld DE,signoffmessage
exit:	ld  c,09h
	jp BDOS			; print string


helptext:
	db CR,LF,'Use: FORMAT VVV  -- VVV is volume number.'
	db CR,LF,'     3 < VVV < 256 ! No system disks.',CR,LF
	db CR,LF,'     Leading zeros not required.',CR,LF,'$'
abortmessage:
	db CR,LF,'Aborted',CR,LF,'$'
numbermessage:
	db CR,LF,'Malformed volume number',CR,LF,'$'
signoffmessage:
	db CR,LF,'Format OK',CR,LF,'$'


FMQUERY: db CR,LF,'Formatting volume '
VNUM:	db'000. Proceed? $'

volImg:	
db 0,'  Volume'
LNUM: db '000',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
empty:
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h
db 0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h,0E5h


