    ; Port Address Equates
CON$ST	equ	0		; console status port
CON$D	equ	1		; console data port
LST$ST	equ	2		; printer status port
LST$D	equ	3		; printer data port
AUX$D	equ	5		; auxiliary data port
SD$DSK	equ	10		; disk drive
SD$TKL	equ	11		; disk track low
SD$TKH	equ	12		; disk track high
SD$SEC	equ	13		; disk sector
SD$CMD	equ	14		; disk command
SD$STAT	equ	15		; disk status
DMA$L	equ	16		; dma address low
DMA$H	equ	17		; dma address high
BANK	equ	18		; select memory bank

LF	equ	0AH		; line feed
CR	equ	0DH		; carriage return
CLS	equ	0Ch		; clear screen (FF)

	org $

	jmp boot
	jmp nooper
	jmp nooper
	jmp nooper
	jmp conout
	jmp nooper
	jmp nooper
	jmp nooper
	jmp home
	jmp seldsk
	jmp settrk
	jmp setsec
	jmp setdma
	jmp read
	jmp nooper
	jmp nooper
	jmp scrtn
	jmp nooper
	jmp nooper
	jmp nooper
	jmp nooper
	jmp nooper
	jmp nooper
	jmp nooper
	jmp nooper
	jmp ?move
	jmp nooper
	jmp nooper
	jmp nooper
	jmp nooper
	jmp 00000h
	jmp 00000h
	jmp 00000h

;	dw sd$write
;	dw sd$read
;	dw sd$login
;	dw sd$init
;	db 0,0			; relative drive zero
rhd0:	dw 0			; XLT
	db 0,0,0,0,0,0,0,0,0	; null
	db 0			; MF
	dw dpbhd8s		; DPP
	dw 0			; CSV
	dw alv0			; ALV
	dw dirbcb0		; DIRBCB
	dw dtabcb0		; DTABCB
	dw 0FFFFh		; HASH
	db 0			; HBANK

alv0:	ds 505

dpbhd8s:
	dw 128		; SPT - sectors per track
	db 5		; BSH - block shift factor
	db 31		; BLM - block mask
	db 1		; EXM - Extent mask
	dw 2043		; 2047-4) DSM - Storage size (blocks - 1)
	dw 511		; DRM - Number of directory entries - 1
	db 11110000b	; AL0 - 1 bit set per directory block
	db 0		; AL1 -            "
	dw 8000h	; CKS - DIR check vector size (DRM+1)/4
	dw 1		; OFF - Reserved tracks
	db 0		; PSH
	db 0		; PSM

dirbcb0:
	db 0ffh		; drv
	ds 3		; rec
	db 0		; wflg
	db 0		; null
	dw 0		; track
	dw 0		; sector
	dw dirbuf0	; buffer address

dirbuf0:
	ds 512

dtabcb0:
	db 0ffh		; drv
	ds 3		; rec
	db 0		; wflg
	db 0		; null
	dw 0		; track
	dw 0		; sector
	dw dtabuf0	; buffer address

dtabuf0:
	ds 512

mnttab db 3

signon:
	db CR,CLS,'CP/M V3.0 LoaderBIOS',CR,LF
	db 'For CP/Mega88, brainchild of Takashi Toyoshima',CR,LF,LF,0


boot:
	di
	lda 0FFFFh ! sta mnttab
	lxi h,signon ! call print
	ret

nooper:
	ret

	; character output
conout:	mov a,c ! out CON$D
	ret

home:	lxi b,00000h

settrk:	
	mov a,c ! out SD$TKL ! mov a,b ! out SD$TKH ! ret

seldsk:
	lda mnttab ! out SD$DSK ! lxi h,rhd0 ! ret

setsec:	
	mov a,c ! out SD$SEC ! ret

scrtn:
	mov h,b ! mov l,c ! ret

setdma:	
	mov a,c ! out DMA$L ! mov a,b ! out DMA$H ! ret

read:
	xra a ! out SD$CMD ! ret

print:
	mov a,m					; get character
	ora a ! rz				; quit if zero
	mov c,a ! call conout			; output character
	inx h ! jmp print			; go for more

?move:
ldir:	ldax d ! mov m,a		; DE - source, HL = dest, BC = length
	inx d ! inx h ! dcx b 
	mov a,b ! ora c ! jnz ldir
	ret

	end
