; bootsector to be used with CP/M 2.2 - start system track sector 1

ccp		equ 0E400h	; Base of CCP
bdos		equ ccp + 0806h	; Base of BDOS
bios		equ ccp + 1600h	; Base of BIOS

CON_D	equ	1		; console data port
SD_DSK	equ	10		; disk drive
SD_TKL	equ	11		; disk track low
SD_TKH	equ	12		; disk track high
SD_SEC	equ	13		; disk sector
SD_CMD	equ	14		; disk command
SD_STAT	equ	15		; disk status
DMA_L	equ	16		; dma address low
DMA_H	equ	17		; dma address high
BANK	equ	18		; memory bank select

	org	0


	ld HL,message
print:	ld A,(HL)
	or A
	jp z,load
	out (CON_D),A
	inc HL
	jp print

load:	ld a,(100h)			; select volume
	out (SD_DSK),A		; set disk drive
	xor A
	out (SD_TKL),A		; set track low
	out (SD_TKH),A		; set track high
	ld BC,1			; set start sector (0 = boot loader)
	ld DE,128		; block size
	ld HL,ccp		; destination


;  loading system track to CCP - FFFFh
load1:	ld A,C			; get sector number
	out (SD_SEC),A		; set it
	ld A,L			; get low order desination address
	out (DMA_L),A		; set it
	ld A,H			; high order destination address
	out (DMA_H),A		; set it
	xor A			; set disk read operatiom
	out (SD_CMD),A		; sector data to destination address
	add HL,DE		; calculate next destination address
	jp c,bios		; if carry, we're at memory top -- exit
	inc C			; point to next disk sector
	jp load1		; repeat...

message:
	db 'Boot phase 0',0

	ds 80h - $

	end
