module ROMbootCF( 
    input [4:0]addr, 
    output reg [7:0]ROMdata); 
    always @(*)
    begin
    //embedded Z80 instruction in ROM
    //Tiny ROM just boot from CF
        case(addr)
        5'b00000: ROMdata = 8'h00; //
        5'b00001: ROMdata = 8'h00; 
        5'b00010: ROMdata = 8'h00; //
        5'b00011: ROMdata = 8'h00; // 
        5'b00100: ROMdata = 8'h21; //
        5'b00101: ROMdata = 8'h00; //  
        5'b00110: ROMdata = 8'hB0; // 
        5'b00111: ROMdata = 8'hDB; // 
        5'b01000: ROMdata = 8'h17; // 
        5'b01001: ROMdata = 8'h17; // 
        5'b01010: ROMdata = 8'h38; // 
        5'b01011: ROMdata = 8'hFB; //  
        5'b01100: ROMdata = 8'h0E; // 
        5'b01101: ROMdata = 8'h10; //  
        5'b01110: ROMdata = 8'h3E; //  
        5'b01111: ROMdata = 8'h20; //
        5'b10000: ROMdata = 8'hD3; //      
        5'b10001: ROMdata = 8'h17; // 
        5'b10010: ROMdata = 8'hDB; //  
        5'b10011: ROMdata = 8'h17; //  
        5'b10100: ROMdata = 8'hE6; //  
        5'b10101: ROMdata = 8'h08; // 
        5'b10110: ROMdata = 8'h28; // 
        5'b10111: ROMdata = 8'hFA; // 
        5'b11000: ROMdata = 8'hED; // 
        5'b11001: ROMdata = 8'hB2; // 
        5'b11010: ROMdata = 8'hC3; // 
        5'b11011: ROMdata = 8'h00; // 
        5'b11100: ROMdata = 8'hB0; // 
        5'b11101: ROMdata = 8'h00; // 
        5'b11110: ROMdata = 8'h00; // 
        5'b11111: ROMdata = 8'h00; // 
 
        endcase
    end
endmodule