module ROMCPLDCF( 
    input [5:0]addr, 
    output reg [7:0]ROMdata); 
    always @(*)
    begin
    //embedded Z80 instruction in ROM
        case(addr)
        6'b000000: ROMdata = 8'h21; //
        6'b000001: ROMdata = 8'h00; 
        6'b000010: ROMdata = 8'hB0; //
        6'b000011: ROMdata = 8'h06; // 
        6'b000100: ROMdata = 8'h09; //
        6'b000101: ROMdata = 8'hDB; //  
        6'b000110: ROMdata = 8'h80; // 
        6'b000111: ROMdata = 8'h1F; // 
        6'b001000: ROMdata = 8'h38; // 
        6'b001001: ROMdata = 8'h20; // 
        6'b001010: ROMdata = 8'h13; // 
        6'b001011: ROMdata = 8'h7A; //  
        6'b001100: ROMdata = 8'hB3; // 
        6'b001101: ROMdata = 8'h20; //  
        6'b001110: ROMdata = 8'hF6; //  
        6'b001111: ROMdata = 8'h78; //
        6'b010000: ROMdata = 8'hFE; //      
        6'b010001: ROMdata = 8'h04; //
        6'b010010: ROMdata = 8'h20; //  
        6'b010011: ROMdata = 8'h04; //  
        6'b010100: ROMdata = 8'h3E; //  
        6'b010101: ROMdata = 8'h20; // 
        6'b010110: ROMdata = 8'hD3; // 
        6'b010111: ROMdata = 8'h17; // 
        6'b011000: ROMdata = 8'hF6; // 
        6'b011001: ROMdata = 8'h30; // 
        6'b011010: ROMdata = 8'hD3; // 
        6'b011011: ROMdata = 8'h81; // 
        6'b011100: ROMdata = 8'h05; // 
        6'b011101: ROMdata = 8'h20; // 
        6'b011110: ROMdata = 8'hE6; // 
        6'b011111: ROMdata = 8'hDB; //      

        6'b100000: ROMdata = 8'h17; //
        6'b100001: ROMdata = 8'h17; 
        6'b100010: ROMdata = 8'h38; //
        6'b100011: ROMdata = 8'h05; // 
        6'b100100: ROMdata = 8'h0E; //
        6'b100101: ROMdata = 8'h10; //  
        6'b100110: ROMdata = 8'hED; // 
        6'b100111: ROMdata = 8'hB2; // 
        6'b101000: ROMdata = 8'h25; // 
        6'b101001: ROMdata = 8'hE9; // 
        6'b101010: ROMdata = 8'hDB; // 
        6'b101011: ROMdata = 8'h81; //  
        6'b101100: ROMdata = 8'h77; // 
        6'b101101: ROMdata = 8'h2C; //  
        6'b101110: ROMdata = 8'h20; //  
        6'b101111: ROMdata = 8'hD5; //
        6'b110000: ROMdata = 8'hE9; //      
        6'b110001: ROMdata = 8'h00; //
        6'b110010: ROMdata = 8'h00; //  
        6'b110011: ROMdata = 8'h00; //  
        6'b110100: ROMdata = 8'h00; //  
        6'b110101: ROMdata = 8'h00; // 
        6'b110110: ROMdata = 8'h00; // 
        6'b110111: ROMdata = 8'h00; // 
        6'b111000: ROMdata = 8'h00; // 
        6'b111001: ROMdata = 8'h00; // 
        6'b111010: ROMdata = 8'h00; // 
        6'b111011: ROMdata = 8'h00; // 
        6'b111100: ROMdata = 8'h00; // 
        6'b111101: ROMdata = 8'h00; // 
        6'b111110: ROMdata = 8'h00; // 
        6'b111111: ROMdata = 8'h00; //      

        endcase
    end
endmodule