;1/20/23
;Put up a screen of description of the VGA display
VGAbase	equ 00h		;beginning of VGA I/O address
VGAfont	equ 0ch		;beginning of font I/O address
fontTop	equ 0fh		;last font I/O address  

	org 100h
	jp start
oldSP:	ds 2
start:
	ld (oldSP),sp		;save CP/M stack
	ld sp,stack

; clear VGA video RAM
	ld c,VGAbase		;point to first line of display memory
	xor a
	ld b,a			;clear regB
	ld e,16			;clear 12 lines plus 4 font tables
clrline:
	out (c),a
	djnz clrline
	inc c
	dec e
	jp nz,clrline

;initialize 4x2 sub_block fonts
	ld hl,gFontEnd-1		;start from end of the graphic font table
	ld b,0
	ld c,VGAfont+3		;initialize last 32 fonts
	otdr
	dec c
	otdr
	dec c
	otdr
	dec c
	otdr
;write out pic file
;pic resolution is 256 horizontal x 192 vertical
;skip every other horizontal line to fit 96 vertical line
;read two bytes, first byte from line N, skip a line, 2nd byte from line N+2
;  assemble into two bytes by taking high nibbles of the two bytes, then low nibbles of the two bytes
;  program is simplified by putting picture on page boundary
	ld hl,Pic
	ld de,Pic+64	;each line is 32 bytes, so 64 skips over a line
	ld bc,0		;first line first char of video memory
wrPic:
	rld		;get high nibble in regA
	rla		;shift to regA high nibble
	rla
	rla
	rla
	ex de,hl
	rld		;get 2nd byte high nibble in regA low nibble
	jp p,putChar
;if bit 7 (msb) set, need to compute index by inverting bits 0-6
	xor 7fh
putChar:
	out (c),a
	ex de,hl
	inc b
;do again
	rld		;get high nibble in regA
	rla		;shift to regA high nibble
	rla
	rla
	rla
	ex de,hl
	rld		;get 2nd byte high nibble in regA low nibble
	jp p,putChar1
;if bit 7 (msb) set, need to compute index by inverting bits 0-6
	xor 7fh
putChar1:
	out (c),a
	ex de,hl
;finish processing a pair of data, setup to process next pair

	inc de
	inc hl
	ld a,l
	and 1fh		;reaching end of a line?
	jr nz,wBlk1
;reaching end of a line, adjust HL, DE for next pair of lines
	ld a,l
	or a		;test regL
	jp p,updatePtr
;this case h is 1010 0000, e is 1110 0000
	inc h
	inc d
	ld l,0
	ld e,40h		;64-byte offset from HL
	jr wBlk1
updatePtr:
;this case h is 0010 0000, e is 0110 0000
	ld l,80h
	ld e,0c0h		;64 byte offset from HL
wBlk1:
	inc b
	jr nz,wrPic
	inc c
	ld a,VGAfont	;reaching top of video RAM?
	cp c
	jr nz,wrPic

	ld sp,(oldSP)		;restore CP/M stack
	ret

;Font table
graphicFont:
	db 0,0,0,0,0,0,0,0
	db 0,0,0,0,00000011b,00000011b,00000011b,00000011b
	db 0,0,0,0,00001100b,00001100b,00001100b,00001100b
	db 0,0,0,0,00001111b,00001111b,00001111b,00001111b
	db 0,0,0,0,00110000b,00110000b,00110000b,00110000b
	db 0,0,0,0,00110011b,00110011b,00110011b,00110011b
	db 0,0,0,0,00111100b,00111100b,00111100b,00111100b
	db 0,0,0,0,00111111b,00111111b,00111111b,00111111b
	db 0,0,0,0,11000000b,11000000b,11000000b,11000000b
	db 0,0,0,0,11000011b,11000011b,11000011b,11000011b
	db 0,0,0,0,11001100b,11001100b,11001100b,11001100b
	db 0,0,0,0,11001111b,11001111b,11001111b,11001111b
	db 0,0,0,0,11110000b,11110000b,11110000b,11110000b
	db 0,0,0,0,11110011b,11110011b,11110011b,11110011b
	db 0,0,0,0,11111100b,11111100b,11111100b,11111100b
	db 0,0,0,0,11111111b,11111111b,11111111b,11111111b
	db 3,3,3,3,0,0,0,0
	db 3,3,3,3,00000011b,00000011b,00000011b,00000011b
	db 3,3,3,3,00001100b,00001100b,00001100b,00001100b
	db 3,3,3,3,00001111b,00001111b,00001111b,00001111b
	db 3,3,3,3,00110000b,00110000b,00110000b,00110000b
	db 3,3,3,3,00110011b,00110011b,00110011b,00110011b
	db 3,3,3,3,00111100b,00111100b,00111100b,00111100b
	db 3,3,3,3,00111111b,00111111b,00111111b,00111111b
	db 3,3,3,3,11000000b,11000000b,11000000b,11000000b
	db 3,3,3,3,11000011b,11000011b,11000011b,11000011b
	db 3,3,3,3,11001100b,11001100b,11001100b,11001100b
	db 3,3,3,3,11001111b,11001111b,11001111b,11001111b
	db 3,3,3,3,11110000b,11110000b,11110000b,11110000b
	db 3,3,3,3,11110011b,11110011b,11110011b,11110011b
	db 3,3,3,3,11111100b,11111100b,11111100b,11111100b
	db 3,3,3,3,11111111b,11111111b,11111111b,11111111b
	db 0ch,0ch,0ch,0ch,0,0,0,0
	db 0ch,0ch,0ch,0ch,00000011b,00000011b,00000011b,00000011b
	db 0ch,0ch,0ch,0ch,00001100b,00001100b,00001100b,00001100b
	db 0ch,0ch,0ch,0ch,00001111b,00001111b,00001111b,00001111b
	db 0ch,0ch,0ch,0ch,00110000b,00110000b,00110000b,00110000b
	db 0ch,0ch,0ch,0ch,00110011b,00110011b,00110011b,00110011b
	db 0ch,0ch,0ch,0ch,00111100b,00111100b,00111100b,00111100b
	db 0ch,0ch,0ch,0ch,00111111b,00111111b,00111111b,00111111b
	db 0ch,0ch,0ch,0ch,11000000b,11000000b,11000000b,11000000b
	db 0ch,0ch,0ch,0ch,11000011b,11000011b,11000011b,11000011b
	db 0ch,0ch,0ch,0ch,11001100b,11001100b,11001100b,11001100b
	db 0ch,0ch,0ch,0ch,11001111b,11001111b,11001111b,11001111b
	db 0ch,0ch,0ch,0ch,11110000b,11110000b,11110000b,11110000b
	db 0ch,0ch,0ch,0ch,11110011b,11110011b,11110011b,11110011b
	db 0ch,0ch,0ch,0ch,11111100b,11111100b,11111100b,11111100b
	db 0ch,0ch,0ch,0ch,11111111b,11111111b,11111111b,11111111b
	db 0fh,0fh,0fh,0fh,0,0,0,0
	db 0fh,0fh,0fh,0fh,00000011b,00000011b,00000011b,00000011b
	db 0fh,0fh,0fh,0fh,00001100b,00001100b,00001100b,00001100b
	db 0fh,0fh,0fh,0fh,00001111b,00001111b,00001111b,00001111b
	db 0fh,0fh,0fh,0fh,00110000b,00110000b,00110000b,00110000b
	db 0fh,0fh,0fh,0fh,00110011b,00110011b,00110011b,00110011b
	db 0fh,0fh,0fh,0fh,00111100b,00111100b,00111100b,00111100b
	db 0fh,0fh,0fh,0fh,00111111b,00111111b,00111111b,00111111b
	db 0fh,0fh,0fh,0fh,11000000b,11000000b,11000000b,11000000b
	db 0fh,0fh,0fh,0fh,11000011b,11000011b,11000011b,11000011b
	db 0fh,0fh,0fh,0fh,11001100b,11001100b,11001100b,11001100b
	db 0fh,0fh,0fh,0fh,11001111b,11001111b,11001111b,11001111b
	db 0fh,0fh,0fh,0fh,11110000b,11110000b,11110000b,11110000b
	db 0fh,0fh,0fh,0fh,11110011b,11110011b,11110011b,11110011b
	db 0fh,0fh,0fh,0fh,11111100b,11111100b,11111100b,11111100b
	db 0fh,0fh,0fh,0fh,11111111b,11111111b,11111111b,11111111b
;64
	db 30h,30h,30h,30h,0,0,0,0
	db 30h,30h,30h,30h,00000011b,00000011b,00000011b,00000011b
	db 30h,30h,30h,30h,00001100b,00001100b,00001100b,00001100b
	db 30h,30h,30h,30h,00001111b,00001111b,00001111b,00001111b
	db 30h,30h,30h,30h,00110000b,00110000b,00110000b,00110000b
	db 30h,30h,30h,30h,00110011b,00110011b,00110011b,00110011b
	db 30h,30h,30h,30h,00111100b,00111100b,00111100b,00111100b
	db 30h,30h,30h,30h,00111111b,00111111b,00111111b,00111111b
	db 30h,30h,30h,30h,11000000b,11000000b,11000000b,11000000b
	db 30h,30h,30h,30h,11000011b,11000011b,11000011b,11000011b
	db 30h,30h,30h,30h,11001100b,11001100b,11001100b,11001100b
	db 30h,30h,30h,30h,11001111b,11001111b,11001111b,11001111b
	db 30h,30h,30h,30h,11110000b,11110000b,11110000b,11110000b
	db 30h,30h,30h,30h,11110011b,11110011b,11110011b,11110011b
	db 30h,30h,30h,30h,11111100b,11111100b,11111100b,11111100b
	db 30h,30h,30h,30h,11111111b,11111111b,11111111b,11111111b
	db 33h,33h,33h,33h,0,0,0,0
	db 33h,33h,33h,33h,00000011b,00000011b,00000011b,00000011b
	db 33h,33h,33h,33h,00001100b,00001100b,00001100b,00001100b
	db 33h,33h,33h,33h,00001111b,00001111b,00001111b,00001111b
	db 33h,33h,33h,33h,00110000b,00110000b,00110000b,00110000b
	db 33h,33h,33h,33h,00110011b,00110011b,00110011b,00110011b
	db 33h,33h,33h,33h,00111100b,00111100b,00111100b,00111100b
	db 33h,33h,33h,33h,00111111b,00111111b,00111111b,00111111b
	db 33h,33h,33h,33h,11000000b,11000000b,11000000b,11000000b
	db 33h,33h,33h,33h,11000011b,11000011b,11000011b,11000011b
	db 33h,33h,33h,33h,11001100b,11001100b,11001100b,11001100b
	db 33h,33h,33h,33h,11001111b,11001111b,11001111b,11001111b
	db 33h,33h,33h,33h,11110000b,11110000b,11110000b,11110000b
	db 33h,33h,33h,33h,11110011b,11110011b,11110011b,11110011b
	db 33h,33h,33h,33h,11111100b,11111100b,11111100b,11111100b
	db 33h,33h,33h,33h,11111111b,11111111b,11111111b,11111111b
;96
	db 3ch,3ch,3ch,3ch,0,0,0,0
	db 3ch,3ch,3ch,3ch,00000011b,00000011b,00000011b,00000011b
	db 3ch,3ch,3ch,3ch,00001100b,00001100b,00001100b,00001100b
	db 3ch,3ch,3ch,3ch,00001111b,00001111b,00001111b,00001111b
	db 3ch,3ch,3ch,3ch,00110000b,00110000b,00110000b,00110000b
	db 3ch,3ch,3ch,3ch,00110011b,00110011b,00110011b,00110011b
	db 3ch,3ch,3ch,3ch,00111100b,00111100b,00111100b,00111100b
	db 3ch,3ch,3ch,3ch,00111111b,00111111b,00111111b,00111111b
	db 3ch,3ch,3ch,3ch,11000000b,11000000b,11000000b,11000000b
	db 3ch,3ch,3ch,3ch,11000011b,11000011b,11000011b,11000011b
	db 3ch,3ch,3ch,3ch,11001100b,11001100b,11001100b,11001100b
	db 3ch,3ch,3ch,3ch,11001111b,11001111b,11001111b,11001111b
	db 3ch,3ch,3ch,3ch,11110000b,11110000b,11110000b,11110000b
	db 3ch,3ch,3ch,3ch,11110011b,11110011b,11110011b,11110011b
	db 3ch,3ch,3ch,3ch,11111100b,11111100b,11111100b,11111100b
	db 3ch,3ch,3ch,3ch,11111111b,11111111b,11111111b,11111111b
	db 3fh,3fh,3fh,3fh,0,0,0,0
	db 3fh,3fh,3fh,3fh,00000011b,00000011b,00000011b,00000011b
	db 3fh,3fh,3fh,3fh,00001100b,00001100b,00001100b,00001100b
	db 3fh,3fh,3fh,3fh,00001111b,00001111b,00001111b,00001111b
	db 3fh,3fh,3fh,3fh,00110000b,00110000b,00110000b,00110000b
	db 3fh,3fh,3fh,3fh,00110011b,00110011b,00110011b,00110011b
	db 3fh,3fh,3fh,3fh,00111100b,00111100b,00111100b,00111100b
	db 3fh,3fh,3fh,3fh,00111111b,00111111b,00111111b,00111111b
	db 3fh,3fh,3fh,3fh,11000000b,11000000b,11000000b,11000000b
	db 3fh,3fh,3fh,3fh,11000011b,11000011b,11000011b,11000011b
	db 3fh,3fh,3fh,3fh,11001100b,11001100b,11001100b,11001100b
	db 3fh,3fh,3fh,3fh,11001111b,11001111b,11001111b,11001111b
	db 3fh,3fh,3fh,3fh,11110000b,11110000b,11110000b,11110000b
	db 3fh,3fh,3fh,3fh,11110011b,11110011b,11110011b,11110011b
	db 3fh,3fh,3fh,3fh,11111100b,11111100b,11111100b,11111100b
	db 3fh,3fh,3fh,3fh,11111111b,11111111b,11111111b,11111111b

gFontEnd:
	org 1000h
;put picture on page boundary for easy manipulation
Pic:
; 'm_pod-artwork_pool_b910b01b0624d808b6d13ee63f3d4e5d-flower-jars-art-print-P1'h,256x192px
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,034h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,001h,084h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,002h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,018h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,010h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,010h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,020h,018h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,020h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,020h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,011h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,00ah,03ch,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,004h,0c1h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,004h,082h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,008h,081h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,00bh,0c3h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,00ch,038h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,018h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,010h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,030h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,020h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,020h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,060h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,080h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 0c0h,000h,000h,000h,000h,060h,040h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,002h
 db 020h,000h,000h,000h,000h,057h,040h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,018h
 db 040h,000h,000h,000h,000h,000h,080h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,061h
 db 000h,000h,000h,000h,000h,022h,080h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,082h
 db 000h,000h,000h,000h,000h,012h,006h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,002h,000h
 db 000h,000h,000h,000h,000h,00bh,007h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h,002h
 db 000h,000h,000h,000h,000h,004h,005h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h,034h
 db 000h,000h,000h,000h,000h,006h,005h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0a0h
 db 000h,000h,000h,000h,000h,006h,0f8h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,060h
 db 000h,000h,000h,000h,000h,005h,0c6h,040h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,020h
 db 000h,000h,000h,000h,000h,006h,002h,040h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,003h,080h
 db 000h,000h,000h,000h,000h,00ch,001h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,00ch,0c0h
 db 000h,000h,000h,000h,000h,008h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,030h,0cbh
 db 0c0h,000h,000h,000h,000h,010h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,012h,090h
 db 020h,000h,000h,000h,000h,010h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,01ch,0efh
 db 0c0h,000h,000h,000h,000h,030h,030h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,060h
 db 000h,000h,000h,000h,008h,030h,001h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,020h
 db 000h,000h,000h,000h,014h,020h,082h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,018h
 db 000h,000h,000h,000h,010h,000h,082h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,004h
 db 00fh,000h,000h,000h,000h,042h,001h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,004h
 db 009h,000h,000h,000h,002h,046h,022h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,00ch,000h
 db 011h,000h,000h,000h,061h,024h,060h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,00ah,008h
 db 001h,000h,020h,081h,091h,003h,023h,0e0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,041h,038h
 db 000h,080h,0c4h,060h,000h,040h,036h,078h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,0a4h,090h
 db 010h,080h,002h,0b0h,0f8h,080h,026h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,094h,024h
 db 000h,080h,001h,010h,013h,080h,007h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,001h,08ch,040h
 db 021h,000h,03eh,021h,0e3h,0c0h,012h,004h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,002h,000h,082h
 db 07fh,000h,09dh,04ch,023h,080h,016h,00ch,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,002h,000h,080h
 db 080h,004h,07ah,011h,060h,0a0h,016h,054h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,003h,001h,081h
 db 080h,002h,018h,0feh,061h,080h,02ch,008h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,0a2h,080h
 db 080h,001h,022h,004h,063h,008h,06fh,030h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,06eh,000h
 db 000h,000h,0b4h,004h,062h,088h,05ch,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,090h,000h
 db 040h,000h,003h,004h,07eh,088h,07bh,040h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 020h,000h,000h,040h,09ch,080h,0a0h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 010h,000h,000h,040h,088h,080h,0c0h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 06ch,000h,000h,021h,021h,001h,007h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,041h
 db 084h,000h,000h,021h,041h,013h,0b8h,010h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h,0bdh
 db 004h,000h,000h,01bh,081h,014h,00ah,008h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h,082h
 db 004h,000h,000h,01ah,082h,018h,0c0h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,001h,080h
 db 004h,000h,000h,01ah,002h,011h,000h,030h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0c2h
 db 004h,000h,000h,01bh,004h,031h,000h,018h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,022h
 db 004h,000h,000h,01ah,004h,043h,0c0h,030h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,014h
 db 004h,000h,000h,00eh,008h,044h,0bfh,020h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 002h,000h,000h,00eh,010h,088h,02ah,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 002h,000h,000h,005h,021h,030h,010h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 001h,080h,000h,003h,022h,040h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,060h,000h,003h,0c4h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,030h,000h,001h,088h,080h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,018h,000h,003h,081h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,008h,000h,003h,012h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,004h,000h,003h,004h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,002h,038h,004h,024h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,002h,028h,006h,008h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,002h,058h,006h,048h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,001h,050h,002h,008h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,0d0h,009h,008h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,070h,009h,088h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,030h,009h,088h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,018h,009h,010h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,008h,009h,030h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,004h,00ah,020h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,0feh,00ah,041h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,001h,0c2h,00ah,087h,080h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,027h,0c0h,000h
 db 000h,007h,0fah,00ah,0fdh,080h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,0a0h,000h
 db 000h,002h,07fh,01fh,0e1h,080h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,041h,0fch,000h
 db 000h,004h,00fh,0ffh,007h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,018h,062h,000h
 db 000h,000h,000h,0f6h,0f3h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,0e0h,000h,000h,002h,020h,00eh,000h
 db 000h,000h,000h,046h,007h,080h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,0d0h,000h,000h,000h,05bh,0b0h,000h
 db 000h,000h,000h,046h,00fh,080h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,088h,000h,000h,000h,040h,060h,000h
 db 000h,004h,007h,024h,03bh,040h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,088h,000h,000h,000h,000h,0e0h,000h
 db 000h,008h,007h,0ffh,0c5h,0b0h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,0e0h,0f3h,080h,000h,000h,080h,0e0h,000h
 db 000h,018h,003h,0ffh,0f8h,0cch,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,003h,094h,004h,040h,000h,000h,080h,0e0h,000h
 db 000h,020h,000h,03ch,000h,07bh,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,004h,01fh,004h,060h,000h,000h,080h,0e0h,000h
 db 000h,040h,000h,01ch,000h,00fh,080h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,006h,035h,08ch,040h,000h,000h,080h,060h,000h
 db 001h,080h,000h,018h,0c0h,003h,040h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,001h,0dah,084h,040h,000h,000h,080h,0a0h,000h
 db 002h,000h,000h,018h,0c0h,001h,0a0h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,00eh,083h,000h,000h,000h,080h,0a0h,000h
 db 004h,000h,000h,018h,0c0h,000h,0d0h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,003h,001h,000h,000h,000h,080h,0a0h,000h
 db 008h,000h,000h,018h,080h,000h,068h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,001h,000h,000h,000h,080h,010h,000h
 db 010h,000h,000h,018h,080h,000h,02ch,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,081h,000h,000h,001h,000h,048h,000h
 db 020h,000h,000h,018h,0a0h,000h,034h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,0b0h,000h,000h,000h,000h,046h,000h
 db 040h,000h,000h,018h,0a0h,000h,01ah,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,0eah,000h,000h,002h,000h,021h,080h
 db 080h,000h,000h,03ch,060h,000h,00ah,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,0c8h,000h,000h,018h,000h,010h,070h
 db 080h,000h,000h,024h,050h,000h,00fh,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,0c4h,000h,000h,040h,000h,018h,01dh
 db 000h,000h,000h,062h,050h,000h,005h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,044h,000h,000h,080h,000h,00ch,007h
 db 000h,000h,000h,061h,030h,000h,007h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,020h,000h,002h,000h,000h,006h,003h
 db 080h,000h,000h,081h,0a8h,000h,003h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,038h,000h,008h,000h,000h,001h,082h
 db 0c0h,000h,000h,0c0h,098h,000h,003h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,010h,000h,000h,000h,064h
 db 060h,000h,001h,040h,094h,000h,001h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,008h,004h,000h,020h,000h,000h,000h,014h
 db 060h,000h,001h,000h,04ah,000h,001h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,014h,004h,000h,040h,000h,000h,000h,00ch
 db 030h,000h,002h,000h,049h,000h,001h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,004h,008h,000h,000h,000h,000h,004h
 db 030h,000h,006h,080h,041h,000h,000h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,013h,004h,034h,080h,000h,000h,000h,00ah
 db 008h,000h,004h,080h,044h,080h,000h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,00dh,004h,024h,000h,000h,000h,000h,008h
 db 018h,000h,008h,080h,064h,040h,000h,0e0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,003h,004h,023h,018h,000h,000h,000h,009h
 db 018h,000h,018h,080h,060h,020h,000h,0e0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,084h,024h,01ch,000h,000h,000h,000h
 db 008h,000h,010h,000h,062h,020h,000h,0e0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,040h,01ch,01ch,000h,000h,000h,000h
 db 08ch,000h,030h,000h,022h,010h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,040h,00fh,0ach,000h,000h,000h,010h
 db 08ch,000h,020h,000h,022h,010h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,020h,018h,05ch,000h,000h,000h,010h
 db 004h,000h,020h,000h,022h,000h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,010h,024h,058h,000h,000h,000h,010h
 db 004h,000h,060h,000h,022h,008h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,0f8h,047h,088h,000h,000h,000h,010h
 db 044h,000h,040h,000h,022h,008h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,0f8h,044h,008h,000h,000h,000h,010h
 db 044h,000h,040h,000h,012h,008h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,02ch,040h,009h,080h,000h,000h,010h
 db 046h,000h,040h,000h,012h,008h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,024h,040h,00ah,040h,000h,000h,010h
 db 042h,000h,0c1h,000h,00ah,000h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,046h,048h,004h,040h,000h,000h,010h
 db 002h,000h,081h,000h,00ah,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,086h,048h,018h,040h,000h,000h,010h
 db 002h,000h,081h,000h,00ah,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,003h,048h,012h,080h,000h,000h,010h
 db 002h,000h,080h,000h,00ah,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,001h,0cbh,0d0h,000h,000h,000h,010h
 db 002h,000h,082h,000h,00ah,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,0ceh,0e0h,000h,000h,000h,010h
 db 002h,000h,082h,001h,0d2h,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,001h,0ffh,0f0h,000h,000h,000h,010h
 db 002h,001h,000h,001h,012h,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,007h,0c9h,0fch,000h,000h,000h,010h
 db 002h,001h,000h,001h,0d2h,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,00eh,008h,043h,000h,000h,000h,010h
 db 002h,001h,004h,001h,092h,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,00fh,0ffh,0c3h,000h,000h,000h,010h
 db 002h,001h,004h,000h,012h,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,00ch,028h,0ffh,080h,000h,000h,010h
 db 002h,003h,07fh,0ffh,0ffh,0c4h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,007h,0e8h,09ch,080h,000h,000h,010h
 db 006h,003h,000h,000h,012h,00fh,080h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,0ffh,0e0h,080h,000h,000h,008h
 db 006h,03ah,008h,000h,012h,004h,070h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,028h,080h,080h,000h,000h,008h
 db 00fh,082h,000h,000h,010h,004h,004h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,010h,008h,080h,080h,000h,000h,00fh
 db 0ceh,002h,000h,000h,010h,004h,002h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,010h,008h,080h,080h,000h,000h,009h
 db 0e4h,01fh,0ffh,0f8h,01ch,004h,000h,060h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,008h,080h,0c0h,000h,000h,00eh
 db 004h,002h,010h,003h,09ch,004h,007h,0e0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,008h,080h,0c0h,000h,000h,00ch
 db 004h,002h,000h,000h,03eh,004h,03dh,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,020h,018h,000h,040h,000h,000h,006h
 db 04ch,002h,000h,000h,01ch,07fh,0e0h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,018h,040h,060h,000h,000h,005h
 db 0cch,002h,020h,000h,008h,007h,001h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,040h,018h,040h,020h,000h,000h,004h
 db 07fh,0ffh,0e3h,0f0h,008h,0f8h,001h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,018h,040h,030h,000h,000h,004h
 db 048h,001h,000h,000h,03eh,008h,002h,0c0h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,080h,008h,020h,030h,000h,000h,004h
 db 048h,001h,040h,000h,006h,008h,004h,0c0h,004h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,008h,020h,010h,000h,000h,004h
 db 008h,001h,000h,000h,006h,008h,038h,0ech,040h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,000h,00ch,000h,018h,000h,000h,006h
 db 008h,000h,080h,000h,006h,009h,0c0h,084h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,000h,00eh,011h,018h,000h,000h,006h
 db 018h,002h,000h,000h,002h,07ch,001h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,00fh,011h,008h,000h,000h,006h
 db 050h,003h,000h,000h,003h,010h,001h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,00ah,070h,00ch,000h,000h,006h
 db 060h,002h,000h,000h,00eh,010h,001h,080h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,000h,00bh,0b2h,00ch,000h,000h,007h
 db 0e0h,002h,000h,000h,012h,010h,001h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,008h,07ch,00ch,000h,000h,03fh
 db 080h,002h,000h,000h,013h,010h,001h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,008h,019h,004h,000h,001h,0ffh
 db 000h,004h,000h,000h,003h,000h,003h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,0ceh,004h,000h,00fh,0c3h
 db 000h,004h,000h,07fh,0f3h,060h,003h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,004h,03fh,0ffh,0ffh,0ffh,001h
 db 000h,004h,003h,090h,06fh,0e0h,002h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,004h,007h,004h,0ffh,0e0h,001h
 db 080h,008h,00ch,020h,013h,0a0h,006h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,004h,002h,004h,000h,000h,001h
 db 080h,008h,030h,040h,01bh,0e0h,006h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,004h,002h,004h,000h,000h,000h
 db 086h,010h,040h,040h,013h,060h,004h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,000h,002h,001h,004h,000h,000h,000h
 db 0c8h,0d1h,080h,080h,017h,020h,00ch,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,07fh,082h,000h,004h,000h,000h,000h
 db 044h,033h,001h,000h,013h,030h,008h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,003h,080h,03fh,0ffh,0fch,000h,000h,000h
 db 064h,01eh,002h,000h,013h,038h,018h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,003h,000h,001h,080h,00ch,000h,000h,000h
 db 034h,017h,004h,000h,013h,028h,010h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,0c0h,000h,080h,04ch,000h,000h,000h
 db 01ch,018h,078h,000h,016h,084h,030h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,002h,01fh,007h,0ffh,0fch,000h,000h,000h
 db 01fh,088h,000h,000h,036h,044h,060h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,0f8h,020h,00ch,000h,000h,000h
 db 01bh,0f0h,000h,000h,02ah,063h,0c0h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,000h,000h,020h,028h,000h,000h,000h
 db 00eh,0f2h,000h,000h,02ah,05fh,080h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,001h,000h,000h,010h,028h,000h,000h,000h
 db 007h,018h,0c0h,000h,072h,043h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,080h,000h,010h,018h,000h,000h,000h
 db 001h,0eeh,000h,000h,062h,08eh,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,080h,000h,008h,018h,000h,000h,000h
 db 000h,09fh,0fch,000h,0ddh,0f8h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,040h,01fh,0e8h,010h,000h,000h,000h
 db 000h,020h,07fh,0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,040h,070h,03ch,010h,000h,000h,000h
 db 000h,008h,003h,0ffh,0feh,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,021h,0c7h,07eh,030h,000h,000h,000h
 db 000h,030h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,013h,030h,007h,020h,000h,000h,000h
 db 003h,080h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,00fh,0c0h,005h,0e0h,003h,0c0h,003h
 db 0f0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,007h,0ffh,003h,0c7h,080h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,001h,0ffh,0ffh,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 db 0ffh,0ffh,0ffh,0ffh,0fch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
 db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,01fh,0ffh,0ffh,0ffh,0ffh
 
 
	ds 64
stack:
	end
 ; 'm_pod-artwork_pool_b910b01b0624d808b6d13ee63f3d4e5d-flower-jars-art-print-P1'h,128x96px
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,002h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,022h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,042h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,008h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,021h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,008h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,024h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,040h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,040h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,080h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,001h,000h,000h,00ch,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,004h,000h,000h,001h,080h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,011h,000h,000h,000h,020h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,004h,000h,000h,001h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,008h,000h,000h,000h,0e8h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,010h,000h,000h,002h,018h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,040h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,06dh,000h,000h,004h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,020h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,002h,000h,000h,055h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,002h,000h,000h,058h,060h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,030h,040h,029h,018h,05ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,0c4h,048h,024h,008h,052h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,001h,008h,040h,041h,018h,020h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,008h,000h,041h,0cch,06ah,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,060h,080h,020h,098h,030h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,040h,000h,00ah,0e0h,0e8h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,060h,002h,060h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,00dh,000h,005h,080h,020h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,005h,010h,00ah,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,008h,000h,001h,020h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,002h,000h,002h,00ah,0b0h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,010h,001h,010h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,004h,001h,0a8h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,002h,001h,010h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,041h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,001h,023h,020h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,003h,080h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,041h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,001h,040h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,03fh,0f0h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,004h,000h,001h,0c2h,0b8h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,005h,0e0h,002h,07fh,090h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,007h,080h,000h,00fh,090h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,018h,000h,003h,0c0h,000h,002h,038h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,00ch,000h,008h,080h,002h,01fh,02ch,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,001h,032h,000h,000h,000h,000h,006h,007h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,001h,082h,000h,000h,000h,010h,006h,081h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,030h,000h,000h,040h,020h,000h,000h,080h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,080h,040h,000h,080h,060h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,005h,000h,010h,010h,080h,006h,0c0h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,00ah,000h,040h,046h,000h,004h,040h,030h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,002h,000h,000h,021h,000h,008h,040h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,002h,000h,000h,008h,080h,000h,0a0h,018h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,020h,000h,000h,002h,040h,018h,090h,008h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,050h,060h,000h,002h,040h,000h,020h,008h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,012h,000h,000h,001h,020h,020h,000h,008h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,00ah,054h,000h,000h,020h,040h,004h,00ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,002h,02eh,000h,000h,0a0h,000h,010h,00ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,002h,008h,000h,000h,0a0h,000h,050h,00ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,012h,080h,000h,000h,000h,080h,012h,00ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,002h,0a0h,000h,004h,000h,080h,012h,00ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,001h,080h,080h,004h,010h,090h,002h,004h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,08ch,000h,004h,010h,000h,082h,004h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,001h,0deh,000h,000h,010h,001h,040h,004h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,003h,0e1h,000h,000h,011h,001h,000h,004h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,003h,04ah,000h,000h,011h,0a1h,0feh,00ch,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,078h,000h,000h,00dh,000h,000h,028h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,040h,080h,002h,07fh,000h,002h,018h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,004h,040h,080h,002h,021h,000h,0c2h,038h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,008h,000h,003h,021h,000h,003h,088h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,008h,000h,040h,002h,031h,003h,0f2h,018h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,020h,040h,002h,021h,000h,000h,02ah,060h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,004h,000h,002h,001h,000h,003h,008h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,010h,00dh,020h,001h,041h,000h,030h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,03ch,020h,001h,080h,000h,014h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,02bh,020h,01dh,000h,001h,0d4h,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,027h,0ffh,0e1h,002h,024h,05ch,010h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,001h,020h,000h,000h,040h,078h,020h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,020h,000h,0a1h,000h,014h,020h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,010h,008h,0a0h,000h,042h,000h,010h,040h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,016h,00eh,020h,000h,032h,040h,05ah,040h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,010h,000h,020h,000h,03ch,000h,03dh,080h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,004h,020h,000h,01ah,000h,049h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,008h,000h,000h,000h,008h,0f9h,0fch,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,0dah,040h,000h,002h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,081h,000h,07eh,020h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,001h,0ffh,0e0h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh
 db 0ffh,0ffh,0e0h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,007h,0ffh,0ffh




