;2/9/23
;display 2x4 block fonts
;run this as a CP/M program
VGAbase	equ 00h		;beginning of VGA I/O address
VGAfont	equ 0ch		;beginning of font I/O address
fontTop	equ 0fh		;last font I/O address  

	org 100h
	jp start
oldSP:	ds 2
start:
	ld (oldSP),sp		;save CP/M stack
	ld sp,stack

; clear VGA video RAM
	ld c,VGAbase		;point to first line of display memory
	xor a
	ld b,a			;clear regB
	ld e,16			;clear 12 lines plus 4 font tables
clrline:
	out (c),a
	djnz clrline
	inc c
	dec e
	jp nz,clrline

;initialize 4x2 sub_block fonts
	ld hl,gFontEnd-1		;start from end of the graphic font table
	ld b,0
	ld c,VGAfont+3		;initialize last 32 fonts
	otdr
	dec c
	otdr
	dec c
	otdr
	dec c
	otdr
;write out all fonts to 2nd 4 lines
	ld bc,1
	xor a
allFont:
	out (c),a
	inc b
	inc a
	jr nz,allFont
	ld sp,(oldSP)		;restore CP/M stack
	ret


	org 200h
;Font table

     db 00h,000h,000h,000h,000h,000h,000h,000h,07Eh,081h,0A5h,081h,0A5h,099h,081h,07Eh
     db 3Ch,07Eh,0DBh,0FFh,0C3h,07Eh,03Ch,000h,000h,06Ch,0FEh,0FEh,07Ch,038h,010h,000h
     db 10h,038h,07Ch,0FEh,07Ch,038h,010h,000h,000h,03Ch,018h,0FFh,0FFh,008h,018h,000h
     db 10h,038h,07Ch,0FEh,0FEh,010h,038h,000h,000h,000h,018h,03Ch,018h,000h,000h,000h
     db 0FFh,0FFh,0E7h,0C3h,0E7h,0FFh,0FFh,0FFh,000h,03Ch,042h,081h,081h,042h,03Ch,000h
     db 0FFh,0C3h,0BDh,07Eh,07Eh,0BDh,0C3h,0FFh,01Fh,007h,00Dh,07Ch,0C6h,0C6h,07Ch,000h
     db 00h,07Eh,0C3h,0C3h,07Eh,018h,07Eh,018h,004h,006h,007h,004h,004h,0FCh,0F8h,000h
     db 0Ch,00Ah,00Dh,00Bh,0F9h,0F9h,01Fh,01Fh,000h,092h,07Ch,06Ch,0C6h,06Ch,07Ch,092h
     db 00h,000h,060h,078h,07Eh,078h,060h,000h,000h,000h,006h,01Eh,07Eh,01Eh,006h,000h
     db 18h,07Eh,018h,018h,018h,018h,07Eh,018h,024h,024h,024h,024h,024h,000h,024h,000h
     db 0FFh,0B6h,076h,036h,036h,036h,036h,000h,07Eh,0C1h,0DCh,022h,022h,01Fh,083h,07Eh
     db 00h,000h,000h,07Eh,07Eh,000h,000h,000h,018h,07Eh,018h,018h,07Eh,018h,000h,0FFh
     db 08h,01Ch,008h,008h,008h,008h,008h,000h,008h,008h,008h,008h,008h,01Ch,008h,000h
     db 00h,000h,002h,0FFh,002h,000h,000h,000h,000h,000h,040h,0FFh,040h,000h,000h,000h
     db 00h,000h,000h,0C0h,0C0h,0C0h,0FFh,000h,000h,024h,066h,0FFh,066h,024h,000h,000h
     db 00h,000h,010h,038h,07Ch,0FEh,000h,000h,000h,000h,000h,0FEh,07Ch,038h,010h,000h
     
 db 000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 010h, 038h, 038h, 010h, 010h, 000h, 010h, 000h
 db 06Ch, 06Ch, 048h, 000h, 000h, 000h, 000h, 000h, 000h, 028h, 07Ch, 028h, 028h, 07Ch, 028h, 000h
 db 020h, 038h, 040h, 030h, 008h, 070h, 010h, 000h, 064h, 064h, 008h, 010h, 020h, 04Ch, 04Ch, 000h
 db 020h, 050h, 050h, 020h, 054h, 048h, 034h, 000h, 030h, 030h, 020h, 000h, 000h, 000h, 000h, 000h
 db 010h, 020h, 020h, 020h, 020h, 020h, 010h, 000h, 020h, 010h, 010h, 010h, 010h, 010h, 020h, 000h
 db 000h, 028h, 038h, 07Ch, 038h, 028h, 000h, 000h, 000h, 010h, 010h, 07Ch, 010h, 010h, 000h, 000h
 db 000h, 000h, 000h, 000h, 000h, 030h, 030h, 020h, 000h, 000h, 000h, 07Ch, 000h, 000h, 000h, 000h
 db 000h, 000h, 000h, 000h, 000h, 030h, 030h, 000h, 000h, 004h, 008h, 010h, 020h, 040h, 000h, 000h
 db 038h, 044h, 04Ch, 054h, 064h, 044h, 038h, 000h, 010h, 030h, 010h, 010h, 010h, 010h, 038h, 000h
 db 038h, 044h, 004h, 018h, 020h, 040h, 07Ch, 000h, 038h, 044h, 004h, 038h, 004h, 044h, 038h, 000h
 db 008h, 018h, 028h, 048h, 07Ch, 008h, 008h, 000h, 07Ch, 040h, 040h, 078h, 004h, 044h, 038h, 000h
 db 018h, 020h, 040h, 078h, 044h, 044h, 038h, 000h, 07Ch, 004h, 008h, 010h, 020h, 020h, 020h, 000h
 db 038h, 044h, 044h, 038h, 044h, 044h, 038h, 000h, 038h, 044h, 044h, 03Ch, 004h, 008h, 030h, 000h
 db 000h, 000h, 030h, 030h, 000h, 030h, 030h, 000h, 000h, 000h, 030h, 030h, 000h, 030h, 030h, 020h
 db 008h, 010h, 020h, 040h, 020h, 010h, 008h, 000h, 000h, 000h, 07Ch, 000h, 000h, 07Ch, 000h, 000h
 db 020h, 010h, 008h, 004h, 008h, 010h, 020h, 000h, 038h, 044h, 004h, 018h, 010h, 000h, 010h, 000h
;upper case
 db 038h, 044h, 05Ch, 054h, 05Ch, 040h, 038h, 000h, 038h, 044h, 044h, 044h, 07Ch, 044h, 044h, 000h
 db 078h, 044h, 044h, 078h, 044h, 044h, 078h, 000h, 038h, 044h, 040h, 040h, 040h, 044h, 038h, 000h
 db 078h, 044h, 044h, 044h, 044h, 044h, 078h, 000h, 07Ch, 040h, 040h, 078h, 040h, 040h, 07Ch, 000h
 db 07Ch, 040h, 040h, 078h, 040h, 040h, 040h, 000h, 038h, 044h, 040h, 05Ch, 044h, 044h, 03Ch, 000h
 db 044h, 044h, 044h, 07Ch, 044h, 044h, 044h, 000h, 038h, 010h, 010h, 010h, 010h, 010h, 038h, 000h
 db 004h, 004h, 004h, 004h, 044h, 044h, 038h, 000h, 044h, 048h, 050h, 060h, 050h, 048h, 044h, 000h
 db 040h, 040h, 040h, 040h, 040h, 040h, 07Ch, 000h, 044h, 06Ch, 054h, 044h, 044h, 044h, 044h, 000h
 db 044h, 064h, 054h, 04Ch, 044h, 044h, 044h, 000h, 038h, 044h, 044h, 044h, 044h, 044h, 038h, 000h
 db 078h, 044h, 044h, 078h, 040h, 040h, 040h, 000h, 038h, 044h, 044h, 044h, 054h, 048h, 034h, 000h
 db 078h, 044h, 044h, 078h, 048h, 044h, 044h, 000h, 038h, 044h, 040h, 038h, 004h, 044h, 038h, 000h
 db 07Ch, 010h, 010h, 010h, 010h, 010h, 010h, 000h, 044h, 044h, 044h, 044h, 044h, 044h, 038h, 000h
 db 044h, 044h, 044h, 044h, 044h, 028h, 010h, 000h, 044h, 044h, 054h, 054h, 054h, 054h, 028h, 000h
 db 044h, 044h, 028h, 010h, 028h, 044h, 044h, 000h, 044h, 044h, 044h, 028h, 010h, 010h, 010h, 000h
 db 078h, 008h, 010h, 020h, 040h, 040h, 078h, 000h, 038h, 020h, 020h, 020h, 020h, 020h, 038h, 000h
 db 000h, 040h, 020h, 010h, 008h, 004h, 000h, 000h, 038h, 008h, 008h, 008h, 008h, 008h, 038h, 000h
 db 010h, 028h, 044h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 0FFh
;lower case
 db 030h, 030h, 010h, 000h, 000h, 000h, 000h, 000h, 000h, 000h, 038h, 004h, 03Ch, 044h, 03Ch, 000h
 db 040h, 040h, 078h, 044h, 044h, 044h, 078h, 000h, 000h, 000h, 038h, 044h, 040h, 044h, 038h, 000h
 db 004h, 004h, 03Ch, 044h, 044h, 044h, 03Ch, 000h, 000h, 000h, 038h, 044h, 078h, 040h, 038h, 000h
 db 018h, 020h, 020h, 078h, 020h, 020h, 020h, 000h, 000h, 000h, 03Ch, 044h, 044h, 03Ch, 004h, 038h
 db 040h, 040h, 070h, 048h, 048h, 048h, 048h, 000h, 010h, 000h, 010h, 010h, 010h, 010h, 018h, 000h
 db 008h, 000h, 018h, 008h, 008h, 008h, 048h, 030h, 040h, 040h, 048h, 050h, 060h, 050h, 048h, 000h
 db 010h, 010h, 010h, 010h, 010h, 010h, 018h, 000h, 000h, 000h, 068h, 054h, 054h, 044h, 044h, 000h
 db 000h, 000h, 070h, 048h, 048h, 048h, 048h, 000h, 000h, 000h, 038h, 044h, 044h, 044h, 038h, 000h
 db 000h, 000h, 078h, 044h, 044h, 044h, 078h, 040h, 000h, 000h, 03Ch, 044h, 044h, 044h, 03Ch, 004h
 db 000h, 000h, 058h, 024h, 020h, 020h, 070h, 000h, 000h, 000h, 038h, 040h, 038h, 004h, 038h, 000h
 db 000h, 020h, 078h, 020h, 020h, 028h, 010h, 000h, 000h, 000h, 048h, 048h, 048h, 058h, 028h, 000h
 db 000h, 000h, 044h, 044h, 044h, 028h, 010h, 000h, 000h, 000h, 044h, 044h, 054h, 07Ch, 028h, 000h
 db 000h, 000h, 048h, 048h, 030h, 048h, 048h, 000h, 000h, 000h, 048h, 048h, 048h, 038h, 010h, 060h
 db 000h, 000h, 078h, 008h, 030h, 040h, 078h, 000h, 018h, 020h, 020h, 060h, 020h, 020h, 018h, 000h
 db 010h, 010h, 010h, 000h, 010h, 010h, 010h, 000h, 030h, 008h, 008h, 00Ch, 008h, 008h, 030h, 000h
 db 028h, 050h, 000h, 000h, 000h, 000h, 000h, 000h, 010h, 038h, 06Ch, 044h, 044h, 07Ch, 000h, 000h

gFontEnd:

	ds 64
stack:
	end


