;2/9/23
;display 2x4 block fonts
;run this as a CP/M program
VGAbase	equ 00h		;beginning of VGA I/O address
VGAfont	equ 0ch		;beginning of font I/O address
fontTop	equ 0fh		;last font I/O address  

	org 100h
	jp start
oldSP:	ds 2
start:
	ld (oldSP),sp		;save CP/M stack
	ld sp,stack

; clear VGA video RAM
	ld c,VGAbase		;point to first line of display memory
	xor a
	ld b,a			;clear regB
	ld e,16			;clear 12 lines plus 4 font tables
clrline:
	out (c),a
	djnz clrline
	inc c
	dec e
	jp nz,clrline

;initialize 4x2 sub_block fonts
	ld hl,gFontEnd-1		;start from end of the graphic font table
	ld b,0
	ld c,VGAfont+3		;initialize last 32 fonts
	otdr
	dec c
	otdr
	dec c
	otdr
	dec c
	otdr
;write out all fonts to 2nd 4 lines
	ld bc,1
	xor a
allFont:
	out (c),a
	inc b
	inc a
	jr nz,allFont
	ld sp,(oldSP)		;restore CP/M stack
	ret


	org 200h
;Font table
graphicFont:
	db 0,0,0,0,0,0,0,0
	db 0,0,0,0,00000011b,00000011b,00000011b,00000011b
	db 0,0,0,0,00001100b,00001100b,00001100b,00001100b
	db 0,0,0,0,00001111b,00001111b,00001111b,00001111b
	db 0,0,0,0,00110000b,00110000b,00110000b,00110000b
	db 0,0,0,0,00110011b,00110011b,00110011b,00110011b
	db 0,0,0,0,00111100b,00111100b,00111100b,00111100b
	db 0,0,0,0,00111111b,00111111b,00111111b,00111111b
	db 0,0,0,0,11000000b,11000000b,11000000b,11000000b
	db 0,0,0,0,11000011b,11000011b,11000011b,11000011b
	db 0,0,0,0,11001100b,11001100b,11001100b,11001100b
	db 0,0,0,0,11001111b,11001111b,11001111b,11001111b
	db 0,0,0,0,11110000b,11110000b,11110000b,11110000b
	db 0,0,0,0,11110011b,11110011b,11110011b,11110011b
	db 0,0,0,0,11111100b,11111100b,11111100b,11111100b
	db 0,0,0,0,11111111b,11111111b,11111111b,11111111b
	db 3,3,3,3,0,0,0,0
	db 3,3,3,3,00000011b,00000011b,00000011b,00000011b
	db 3,3,3,3,00001100b,00001100b,00001100b,00001100b
	db 3,3,3,3,00001111b,00001111b,00001111b,00001111b
	db 3,3,3,3,00110000b,00110000b,00110000b,00110000b
	db 3,3,3,3,00110011b,00110011b,00110011b,00110011b
	db 3,3,3,3,00111100b,00111100b,00111100b,00111100b
	db 3,3,3,3,00111111b,00111111b,00111111b,00111111b
	db 3,3,3,3,11000000b,11000000b,11000000b,11000000b
	db 3,3,3,3,11000011b,11000011b,11000011b,11000011b
	db 3,3,3,3,11001100b,11001100b,11001100b,11001100b
	db 3,3,3,3,11001111b,11001111b,11001111b,11001111b
	db 3,3,3,3,11110000b,11110000b,11110000b,11110000b
	db 3,3,3,3,11110011b,11110011b,11110011b,11110011b
	db 3,3,3,3,11111100b,11111100b,11111100b,11111100b
	db 3,3,3,3,11111111b,11111111b,11111111b,11111111b
	db 0ch,0ch,0ch,0ch,0,0,0,0
	db 0ch,0ch,0ch,0ch,00000011b,00000011b,00000011b,00000011b
	db 0ch,0ch,0ch,0ch,00001100b,00001100b,00001100b,00001100b
	db 0ch,0ch,0ch,0ch,00001111b,00001111b,00001111b,00001111b
	db 0ch,0ch,0ch,0ch,00110000b,00110000b,00110000b,00110000b
	db 0ch,0ch,0ch,0ch,00110011b,00110011b,00110011b,00110011b
	db 0ch,0ch,0ch,0ch,00111100b,00111100b,00111100b,00111100b
	db 0ch,0ch,0ch,0ch,00111111b,00111111b,00111111b,00111111b
	db 0ch,0ch,0ch,0ch,11000000b,11000000b,11000000b,11000000b
	db 0ch,0ch,0ch,0ch,11000011b,11000011b,11000011b,11000011b
	db 0ch,0ch,0ch,0ch,11001100b,11001100b,11001100b,11001100b
	db 0ch,0ch,0ch,0ch,11001111b,11001111b,11001111b,11001111b
	db 0ch,0ch,0ch,0ch,11110000b,11110000b,11110000b,11110000b
	db 0ch,0ch,0ch,0ch,11110011b,11110011b,11110011b,11110011b
	db 0ch,0ch,0ch,0ch,11111100b,11111100b,11111100b,11111100b
	db 0ch,0ch,0ch,0ch,11111111b,11111111b,11111111b,11111111b
	db 0fh,0fh,0fh,0fh,0,0,0,0
	db 0fh,0fh,0fh,0fh,00000011b,00000011b,00000011b,00000011b
	db 0fh,0fh,0fh,0fh,00001100b,00001100b,00001100b,00001100b
	db 0fh,0fh,0fh,0fh,00001111b,00001111b,00001111b,00001111b
	db 0fh,0fh,0fh,0fh,00110000b,00110000b,00110000b,00110000b
	db 0fh,0fh,0fh,0fh,00110011b,00110011b,00110011b,00110011b
	db 0fh,0fh,0fh,0fh,00111100b,00111100b,00111100b,00111100b
	db 0fh,0fh,0fh,0fh,00111111b,00111111b,00111111b,00111111b
	db 0fh,0fh,0fh,0fh,11000000b,11000000b,11000000b,11000000b
	db 0fh,0fh,0fh,0fh,11000011b,11000011b,11000011b,11000011b
	db 0fh,0fh,0fh,0fh,11001100b,11001100b,11001100b,11001100b
	db 0fh,0fh,0fh,0fh,11001111b,11001111b,11001111b,11001111b
	db 0fh,0fh,0fh,0fh,11110000b,11110000b,11110000b,11110000b
	db 0fh,0fh,0fh,0fh,11110011b,11110011b,11110011b,11110011b
	db 0fh,0fh,0fh,0fh,11111100b,11111100b,11111100b,11111100b
	db 0fh,0fh,0fh,0fh,11111111b,11111111b,11111111b,11111111b
;64
	db 30h,30h,30h,30h,0,0,0,0
	db 30h,30h,30h,30h,00000011b,00000011b,00000011b,00000011b
	db 30h,30h,30h,30h,00001100b,00001100b,00001100b,00001100b
	db 30h,30h,30h,30h,00001111b,00001111b,00001111b,00001111b
	db 30h,30h,30h,30h,00110000b,00110000b,00110000b,00110000b
	db 30h,30h,30h,30h,00110011b,00110011b,00110011b,00110011b
	db 30h,30h,30h,30h,00111100b,00111100b,00111100b,00111100b
	db 30h,30h,30h,30h,00111111b,00111111b,00111111b,00111111b
	db 30h,30h,30h,30h,11000000b,11000000b,11000000b,11000000b
	db 30h,30h,30h,30h,11000011b,11000011b,11000011b,11000011b
	db 30h,30h,30h,30h,11001100b,11001100b,11001100b,11001100b
	db 30h,30h,30h,30h,11001111b,11001111b,11001111b,11001111b
	db 30h,30h,30h,30h,11110000b,11110000b,11110000b,11110000b
	db 30h,30h,30h,30h,11110011b,11110011b,11110011b,11110011b
	db 30h,30h,30h,30h,11111100b,11111100b,11111100b,11111100b
	db 30h,30h,30h,30h,11111111b,11111111b,11111111b,11111111b
	db 33h,33h,33h,33h,0,0,0,0
	db 33h,33h,33h,33h,00000011b,00000011b,00000011b,00000011b
	db 33h,33h,33h,33h,00001100b,00001100b,00001100b,00001100b
	db 33h,33h,33h,33h,00001111b,00001111b,00001111b,00001111b
	db 33h,33h,33h,33h,00110000b,00110000b,00110000b,00110000b
	db 33h,33h,33h,33h,00110011b,00110011b,00110011b,00110011b
	db 33h,33h,33h,33h,00111100b,00111100b,00111100b,00111100b
	db 33h,33h,33h,33h,00111111b,00111111b,00111111b,00111111b
	db 33h,33h,33h,33h,11000000b,11000000b,11000000b,11000000b
	db 33h,33h,33h,33h,11000011b,11000011b,11000011b,11000011b
	db 33h,33h,33h,33h,11001100b,11001100b,11001100b,11001100b
	db 33h,33h,33h,33h,11001111b,11001111b,11001111b,11001111b
	db 33h,33h,33h,33h,11110000b,11110000b,11110000b,11110000b
	db 33h,33h,33h,33h,11110011b,11110011b,11110011b,11110011b
	db 33h,33h,33h,33h,11111100b,11111100b,11111100b,11111100b
	db 33h,33h,33h,33h,11111111b,11111111b,11111111b,11111111b
;96
	db 3ch,3ch,3ch,3ch,0,0,0,0
	db 3ch,3ch,3ch,3ch,00000011b,00000011b,00000011b,00000011b
	db 3ch,3ch,3ch,3ch,00001100b,00001100b,00001100b,00001100b
	db 3ch,3ch,3ch,3ch,00001111b,00001111b,00001111b,00001111b
	db 3ch,3ch,3ch,3ch,00110000b,00110000b,00110000b,00110000b
	db 3ch,3ch,3ch,3ch,00110011b,00110011b,00110011b,00110011b
	db 3ch,3ch,3ch,3ch,00111100b,00111100b,00111100b,00111100b
	db 3ch,3ch,3ch,3ch,00111111b,00111111b,00111111b,00111111b
	db 3ch,3ch,3ch,3ch,11000000b,11000000b,11000000b,11000000b
	db 3ch,3ch,3ch,3ch,11000011b,11000011b,11000011b,11000011b
	db 3ch,3ch,3ch,3ch,11001100b,11001100b,11001100b,11001100b
	db 3ch,3ch,3ch,3ch,11001111b,11001111b,11001111b,11001111b
	db 3ch,3ch,3ch,3ch,11110000b,11110000b,11110000b,11110000b
	db 3ch,3ch,3ch,3ch,11110011b,11110011b,11110011b,11110011b
	db 3ch,3ch,3ch,3ch,11111100b,11111100b,11111100b,11111100b
	db 3ch,3ch,3ch,3ch,11111111b,11111111b,11111111b,11111111b
	db 3fh,3fh,3fh,3fh,0,0,0,0
	db 3fh,3fh,3fh,3fh,00000011b,00000011b,00000011b,00000011b
	db 3fh,3fh,3fh,3fh,00001100b,00001100b,00001100b,00001100b
	db 3fh,3fh,3fh,3fh,00001111b,00001111b,00001111b,00001111b
	db 3fh,3fh,3fh,3fh,00110000b,00110000b,00110000b,00110000b
	db 3fh,3fh,3fh,3fh,00110011b,00110011b,00110011b,00110011b
	db 3fh,3fh,3fh,3fh,00111100b,00111100b,00111100b,00111100b
	db 3fh,3fh,3fh,3fh,00111111b,00111111b,00111111b,00111111b
	db 3fh,3fh,3fh,3fh,11000000b,11000000b,11000000b,11000000b
	db 3fh,3fh,3fh,3fh,11000011b,11000011b,11000011b,11000011b
	db 3fh,3fh,3fh,3fh,11001100b,11001100b,11001100b,11001100b
	db 3fh,3fh,3fh,3fh,11001111b,11001111b,11001111b,11001111b
	db 3fh,3fh,3fh,3fh,11110000b,11110000b,11110000b,11110000b
	db 3fh,3fh,3fh,3fh,11110011b,11110011b,11110011b,11110011b
	db 3fh,3fh,3fh,3fh,11111100b,11111100b,11111100b,11111100b
	db 3fh,3fh,3fh,3fh,11111111b,11111111b,11111111b,11111111b

gFontEnd:
	ds 64
stack:
	end


