#  biostrap.s
/*
	Copyright (C) 2011,2015 John R. Coffman.
	Licensed for hobbyist use only.
***********************************************************************

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    in the file COPYING in the distribution directory along with this
    program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************/
#
#	Definitions of the  Baby M68000 CPU  BIOS trap calls
#
#
bios		=	8		/* trap #8 used for all BIOS calls */
BIOS		=	8		/* make case insensitive */


#  General usage:
#
#	move.l	param1,%d1
#	move.l	param2,%d2
#	move	address,%a0
#
#	move.b	#<bioscall>,%d0		/* BIOS call number in low byte of D0 */
#	trap	#BIOS
#
#	Carry Clear means no error		<some calls only>
#	Carry Set means an error occurred	<some calls only>
#	Error code usually returned in D0
#	Returned values in D1,D2,... A0,...	<see call description>
#
#
#
#
#
#		   D0 function
#		      code
#
sioput		=	2	/* D1 = character to put out */
siostr		=	3	/* A0 = string ptr, D1 = termination char */
				/* returns D0 = number of chars put out */
sioget		=	4	/* D1 = returned character (waits) */
siotst		=	5	/* D0 = 0, no character available  */
				/* D0 = 1..n, number of characters waiting */

cpuhma		=	6	/* OBSOLETE!!! USE fn 8, D1=0; 
				   old:  return HMA in D0 -- 0x00200000 on max. system */
cpustop		=	7	/* stop execution */
hma_alloc	=	8	/* allocate D1 bytes of highest memory; return HMA (new) in D0 */

/* IDE disk drivers */		/* D1 = disk # for all of the following:   */
disk_reset	=	10	/* D1 = disk # -- may reset entire controller */
disk_info	=	11	/* D1;  A0 = 512 byte buffer for disk ID */
disk_read	=	12	/* D1;  A0 = buffer; D2 = LBA sector; D3 = sector count */
disk_write	=	13	/* ditto */
disk_verify	=	14	/* D1; D2 = LBA sector; D3 = sector count */
/* Floppies only:   */
disk_format	=	15	/* D1; A0 = interleave info/track */
/*
   Disk numbers are 0,1 for floppies; 2..7 for IDE disks
 */

day_time	=	20	/* D1 = return option */


# biostrap.s -- end of file


